package gov.va.vamf.scheduling.communitycare.resource;

import gov.va.vamf.scheduling.communitycare.domain.ApiKeys;
import gov.va.vamf.scheduling.communitycare.service.ApiKeysService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Component
@Path("/api-keys")
@Scope("request")
public class ApiKeysResource {

	@Resource
	ApiKeysService apiKeysService;

	@GET
	@Produces({ "application/json" })
	@Path("/")
	public ApiKeys getApiKeys() {
		return apiKeysService.getApiKeys();
	}
}


